/*
 * Decompiled with CFR 0.152.
 */
package ithakimodem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class Modem {
    Socket port;
    InputStream in;
    OutputStream out;
    JTextArea text;
    KeyListener key;
    static Modem modem;
    Random r;
    int RATE = -1;
    int SPEED = -1;
    int DELAY = -1;
    int DRIFT = 0;
    int CHANGE = 0;
    int count = 0;
    long channel = -1L;
    long temp = -1L;
    long time = 0L;

    public Modem() {
        try {
            this.port = new Socket();
            this.port.setSoTimeout(32000);
            this.port.connect(new InetSocketAddress("155.207.18.208", 19008), 8000);
            this.out = this.port.getOutputStream();
            this.in = this.port.getInputStream();
            this.channel = System.currentTimeMillis();
            this.r = new Random(this.channel);
            this.setSpeed(1000);
        }
        catch (Exception x) {
            System.out.println("\nIthaki Virtual Modem Not Available");
        }
    }

    public Modem(int speed) {
        try {
            this.port = new Socket();
            this.port.setSoTimeout(32000);
            this.port.connect(new InetSocketAddress("155.207.18.208", 19008), 8000);
            this.out = this.port.getOutputStream();
            this.in = this.port.getInputStream();
            this.channel = System.currentTimeMillis();
            this.r = new Random(this.channel);
            if (speed < 0) {
                speed = 1000;
            }
            this.setSpeed(speed);
        }
        catch (Exception x) {
            System.out.println("\nIthaki Virtual Modem Not Available");
        }
    }

    public boolean open(String dest) {
        try {
            if (dest.toUpperCase().equals("ITHAKICOPTER")) {
                System.out.println("call ithakicopter");
                try {
                    this.in.close();
                    this.out.close();
                    this.port.close();
                    Thread.sleep(2000L);
                    this.port = new Socket();
                    this.port.setSoTimeout(32000);
                    this.port.connect(new InetSocketAddress("155.207.18.208", 37078), 8000);
                    System.out.println("connected ithakicopter");
                    this.out = this.port.getOutputStream();
                    this.in = this.port.getInputStream();
                    this.channel = System.currentTimeMillis();
                    this.r = new Random(this.channel);
                    this.setSpeed(1000);
                    return true;
                }
                catch (IOException | InterruptedException x) {
                    System.out.println(x);
                    return false;
                }
            }
            if (dest.toUpperCase().equals("ITHAKI")) {
                this.out.write("ATD2310ITHAKI\r".getBytes());
                return true;
            }
            return false;
        }
        catch (Exception x) {
            return false;
        }
    }

    public void setSpeed(int x) {
        this.RATE = x;
        if (x > 0) {
            this.SPEED = 1;
            this.DELAY = 52;
        }
        if (x > 500) {
            this.SPEED = 1;
            this.DELAY = 16;
        }
        if (x > 1500) {
            this.SPEED = 1;
            this.DELAY = 8;
        }
        if (x > 2500) {
            this.SPEED = 2;
            this.DELAY = 8;
        }
        if (x > 3500) {
            this.SPEED = 1;
            this.DELAY = 4;
        }
        if (x > 4500) {
            this.SPEED = 1;
            this.DELAY = 3;
        }
        if (x > 5500) {
            this.SPEED = 2;
            this.DELAY = 4;
        }
        if (x > 6500) {
            this.SPEED = 5;
            this.DELAY = 7;
        }
        if (x > 7500) {
            this.SPEED = 4;
            this.DELAY = 5;
        }
        if (x > 12000) {
            this.SPEED = 48;
            this.DELAY = 24;
        }
        if (x > 20000) {
            this.SPEED = 77;
            this.DELAY = 25;
        }
        if (x > 28000) {
            this.SPEED = 73;
            this.DELAY = 18;
        }
        if (x > 36000) {
            this.SPEED = 71;
            this.DELAY = 14;
        }
        if (x > 44000) {
            this.SPEED = 73;
            this.DELAY = 12;
        }
        if (x > 52000) {
            this.SPEED = 71;
            this.DELAY = 10;
        }
        if (x > 60000) {
            this.SPEED = 80;
            this.DELAY = 10;
        }
        if (x > 68000) {
            this.SPEED = 45;
            this.DELAY = 5;
        }
        if (x > 76000) {
            this.SPEED = 50;
            this.DELAY = 5;
        }
    }

    public InputStream getInputStream() {
        try {
            return this.in;
        }
        catch (Exception x) {
            return null;
        }
    }

    public OutputStream getOutputStream() {
        try {
            return this.out;
        }
        catch (Exception x) {
            return null;
        }
    }

    public int read() {
        try {
            this.temp = System.currentTimeMillis();
            if (this.temp - this.channel > (long)(1000 + this.CHANGE)) {
                this.DRIFT = (int)((float)this.r.nextInt(5) * (float)this.DELAY / 8.0f);
                this.CHANGE = this.r.nextInt(5800);
                this.channel = this.temp;
            }
            if (++this.count > this.SPEED) {
                Thread.sleep(this.DELAY + this.DRIFT);
                this.count = 0;
            }
            return this.in.read();
        }
        catch (IOException | InterruptedException z) {
            return -1;
        }
    }

    public boolean write(int x) {
        try {
            this.out.write(x);
            return true;
        }
        catch (Exception z) {
            return false;
        }
    }

    public boolean write(byte[] x) {
        try {
            this.out.write(x);
            return true;
        }
        catch (Exception z) {
            return false;
        }
    }

    public boolean setTimeout(int timeout) {
        try {
            this.port.setSoTimeout(timeout);
            return true;
        }
        catch (Exception x) {
            return false;
        }
    }

    public boolean close() {
        try {
            this.in.close();
            this.out.close();
            this.port.close();
            return true;
        }
        catch (Exception x) {
            return false;
        }
    }

    public static void main(String[] param) {
        modem = new Modem(1000);
        modem.virtual();
    }

    private void virtual() {
        int k;
        if (!this.port.isConnected()) {
            return;
        }
        JFrame frame = new JFrame("Ithaki Smart Broadband Modem Terminal Emulator - Experimental Virtual Lab");
        frame.setDefaultCloseOperation(3);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int X = (int)screen.getWidth();
        int Y = (int)screen.getHeight();
        this.text = new JTextArea("");
        Font font = new Font("Courier New", 0, 16);
        this.text.setFont(font);
        this.text.setForeground(Color.BLACK);
        this.key = new terminal();
        this.text.addKeyListener(this.key);
        this.text.setEditable(true);
        JScrollPane scroll = new JScrollPane(this.text);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setPreferredSize(new Dimension(740, 400));
        frame.getContentPane().add((Component)scroll, "Center");
        frame.pack();
        frame.setLocation(X / 2 - 370, Y / 4);
        frame.setVisible(true);
        System.out.println("\nExperimental Virtual Lab\n\nDepartment of Electrical Engineering\nSchool of Engineering\nAristotle University of Thessaloniki\n");
        System.out.println("Close terminal emulator window\n\nor\n\nPress ctrl+C to exit application\n");
        try {
            while ((k = modem.read()) != -1) {
                this.text.append(String.format("%s", Character.valueOf((char)k)));
                k = this.text.getText().length();
                this.text.setCaretPosition(k);
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            this.text.append("\r\n\nMODEM NOT AVAILABLE\n\n");
            k = this.text.getText().length();
            this.text.setCaretPosition(k);
            this.out.close();
            this.in.close();
            this.port = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class terminal
    implements KeyListener {
        String temp;

        @Override
        public void keyTyped(KeyEvent x) {
            if (x.getKeyChar() == '\n') {
                this.temp = Modem.this.text.getText().substring(0, Modem.this.text.getCaretPosition());
                Modem.this.text.setText(this.temp);
                this.temp = this.temp.substring(0, this.temp.length() - 1);
                if (this.temp.lastIndexOf("\n") > -1) {
                    this.temp = this.temp.substring(this.temp.lastIndexOf("\n") + 1);
                }
                this.temp = this.temp.toUpperCase();
                if (this.temp.equals("ATD2310ITHAKI")) {
                    Modem.this.text.append("SPEED ".concat(String.valueOf(Modem.this.RATE)).concat(" bps\n"));
                }
                if (this.temp.equals("ATS")) {
                    Modem.this.text.append("SPEED ".concat(String.valueOf(Modem.this.RATE)).concat(" bps\n"));
                    this.temp = "AT";
                }
                if (this.temp.indexOf("ATS=") == 0) {
                    try {
                        Modem.this.setSpeed(Integer.valueOf(this.temp.substring(4)));
                        Modem.this.text.append("SPEED ".concat(String.valueOf(Modem.this.RATE)).concat(" bps\n"));
                        this.temp = "AT";
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                try {
                    if (Modem.this.port.isConnected()) {
                        modem.write(this.temp.concat("\r").getBytes());
                    } else {
                        Modem.this.text.append("\r\nMODEM NOT AVAILABLE\n\n");
                    }
                }
                catch (Exception z) {
                    Modem.this.text.append("\r\nMODEM NOT AVAILABLE\n\n");
                }
                Modem.this.text.setCaretPosition(Modem.this.text.getText().length());
            }
        }

        @Override
        public void keyPressed(KeyEvent x) {
        }

        @Override
        public void keyReleased(KeyEvent x) {
        }
    }
}

